﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.Specialized;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    [Serializable]
    public class AHOBPRMailManager
    {
        protected Dictionary<int, EMailMessage> messages;
        protected AHOBPREmailService mailService;

        public AHOBPRMailManager(AHOBPREmailService emailService)
        {
            mailService = emailService;
            messages = new Dictionary<int, EMailMessage>();
        }

        //Template with a multiple to addresses
        public void AddTemplate(int templateId, string from, string to)
        {
            if (!(messages.ContainsKey(templateId)))
            {
                EMailMessage msg = mailService.CreateMessage(templateId, from, to);
                messages.Add(templateId, msg);
            }
            messages[templateId].AddRecipient(to);
        }

        //Template with a single to address
        public void AddTemplate(int templateId, string from, StringCollection toList)
        {
            if (!(messages.ContainsKey(templateId)))
            {
                EMailMessage msg = mailService.CreateMessage(templateId, from, toList);
                messages.Add(templateId, msg);
            }
            messages[templateId].AddRecipient(toList);
        }

        public void SendAll(int registrantId, int templateId, int sendMessageType, bool isRegistrant, string createdBy)
        {

            foreach (int item in messages.Keys)
            {
                RemoveEmptyAddresses(messages[item]);
                messages[item].Send(registrantId, templateId, sendMessageType, isRegistrant, createdBy);
            }

        }


        public void RemoveEmptyAddresses(EMailMessage msg)
        {
            if (msg.toList != null && msg.toList.Count > 0)
            {
                List<String> query = (from string name in msg.toList where name != string.Empty select name).ToList();
                msg.toList = new StringCollection();
                msg.toList.AddRange(query.ToArray());
            }

        }

        public void SetField(int templateId, string key, string value)
        {
            if (messages.ContainsKey(templateId))
            {
                messages[templateId].SetField(key, value);
            }
        }

        public void SetField(string key, string value)
        {
            foreach (int item in messages.Keys)
            {
                messages[item].SetField(key, value);
            }
        }
    }
}

